VERSION 2.00
Begin Form Main 
   Caption         =   "VB/ISAM SAMPLE PROGRAM 1"
   ClientHeight    =   6576
   ClientLeft      =   168
   ClientTop       =   480
   ClientWidth     =   9228
   ControlBox      =   0   'False
   FontBold        =   -1  'True
   FontItalic      =   0   'False
   FontName        =   "MS Sans Serif"
   FontSize        =   7.8
   FontStrikethru  =   0   'False
   FontUnderline   =   -1  'True
   Height          =   7092
   Left            =   72
   LinkMode        =   1  'Source
   LinkTopic       =   "Form2"
   ScaleHeight     =   6576
   ScaleWidth      =   9228
   Top             =   60
   Width           =   9420
   Begin CommandButton QuitButton 
      Caption         =   "Quit, don't kill"
      Height          =   315
      Left            =   7320
      TabIndex        =   0
      Top             =   6180
      Width           =   1695
   End
   Begin CommandButton KillQuitButton 
      Caption         =   "Kill, then quit"
      Height          =   315
      Left            =   240
      TabIndex        =   1
      Top             =   6180
      Width           =   1695
   End
   Begin Frame FindFrame 
      Caption         =   "FIND record(s):"
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   12
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   3435
      Left            =   240
      TabIndex        =   24
      Top             =   2640
      Width           =   8775
      Begin ListBox FindList 
         BackColor       =   &H00FFFFFF&
         ForeColor       =   &H000000FF&
         Height          =   984
         Left            =   60
         TabIndex        =   25
         Top             =   2340
         Width           =   8652
      End
      Begin Frame FindTypeFrame 
         Caption         =   "Through the selected index, find which record(s)?"
         Height          =   1575
         Left            =   2760
         TabIndex        =   31
         Top             =   420
         Width           =   5955
         Begin CommandButton FindButton 
            Caption         =   "Last"
            Height          =   255
            Index           =   4
            Left            =   240
            TabIndex        =   40
            Top             =   1260
            Width           =   1395
         End
         Begin CommandButton FindButton 
            Caption         =   "Next (Group)"
            Height          =   255
            Index           =   7
            Left            =   1980
            TabIndex        =   43
            Top             =   1020
            Width           =   1755
         End
         Begin CommandButton FindButton 
            Caption         =   "Next (1)"
            Height          =   255
            Index           =   3
            Left            =   240
            TabIndex        =   39
            Top             =   1020
            Width           =   1395
         End
         Begin CommandButton FindButton 
            Caption         =   "Key Match (Group)"
            Height          =   255
            Index           =   6
            Left            =   1980
            TabIndex        =   42
            Top             =   780
            Width           =   1755
         End
         Begin CommandButton FindButton 
            Caption         =   "Key Match (1)"
            Height          =   255
            Index           =   2
            Left            =   240
            TabIndex        =   38
            Top             =   780
            Width           =   1395
         End
         Begin TextBox MatchKey 
            BackColor       =   &H00C0C0C0&
            Height          =   315
            Left            =   4200
            TabIndex        =   32
            Top             =   720
            Width           =   1695
         End
         Begin CommandButton FindButton 
            Caption         =   "Previous (Group)"
            Height          =   255
            Index           =   5
            Left            =   1980
            TabIndex        =   41
            Top             =   540
            Width           =   1755
         End
         Begin CommandButton FindButton 
            Caption         =   "Previous (1)"
            Height          =   255
            Index           =   1
            Left            =   240
            TabIndex        =   37
            Top             =   540
            Width           =   1395
         End
         Begin CommandButton FindButton 
            Caption         =   "First"
            Height          =   255
            Index           =   0
            Left            =   240
            TabIndex        =   36
            Top             =   300
            Width           =   1395
         End
         Begin Label Label11 
            Caption         =   "(""Group"" includes ""duplicate key"" records)"
            Height          =   195
            Left            =   1860
            TabIndex        =   35
            Top             =   1320
            Width           =   3975
         End
         Begin Label FindIndicator 
            Alignment       =   2  'Center
            Caption         =   "*"
            ForeColor       =   &H000000FF&
            Height          =   135
            Index           =   4
            Left            =   60
            TabIndex        =   48
            Top             =   1260
            Width           =   135
         End
         Begin Label FindIndicator 
            Alignment       =   2  'Center
            Caption         =   "*"
            ForeColor       =   &H000000FF&
            Height          =   135
            Index           =   7
            Left            =   1800
            TabIndex        =   51
            Top             =   1020
            Width           =   135
         End
         Begin Label FindIndicator 
            Alignment       =   2  'Center
            Caption         =   "*"
            ForeColor       =   &H000000FF&
            Height          =   135
            Index           =   3
            Left            =   60
            TabIndex        =   47
            Top             =   1020
            Width           =   135
         End
         Begin Label FindIndicator 
            Alignment       =   2  'Center
            Caption         =   "*"
            ForeColor       =   &H000000FF&
            Height          =   135
            Index           =   6
            Left            =   1800
            TabIndex        =   50
            Top             =   780
            Width           =   135
         End
         Begin Label FindIndicator 
            Alignment       =   2  'Center
            Caption         =   "*"
            ForeColor       =   &H000000FF&
            Height          =   135
            Index           =   2
            Left            =   60
            TabIndex        =   46
            Top             =   780
            Width           =   135
         End
         Begin Label FindIndicator 
            Alignment       =   2  'Center
            Caption         =   "*"
            ForeColor       =   &H000000FF&
            Height          =   135
            Index           =   5
            Left            =   1800
            TabIndex        =   49
            Top             =   540
            Width           =   135
         End
         Begin Label FindIndicator 
            Alignment       =   2  'Center
            Caption         =   "*"
            ForeColor       =   &H000000FF&
            Height          =   135
            Index           =   1
            Left            =   60
            TabIndex        =   45
            Top             =   540
            Width           =   135
         End
         Begin Label MatchKeyLabel 
            Caption         =   "(Match key:)"
            Height          =   195
            Left            =   4200
            TabIndex        =   33
            Top             =   480
            Width           =   1575
         End
         Begin Label FindIndicator 
            Alignment       =   2  'Center
            Caption         =   "*"
            ForeColor       =   &H000000FF&
            Height          =   135
            Index           =   0
            Left            =   60
            TabIndex        =   44
            Top             =   300
            Width           =   135
         End
      End
      Begin Frame IndexFrame 
         Caption         =   "Find by which index?"
         Height          =   1575
         Left            =   60
         TabIndex        =   26
         Top             =   420
         Width           =   2595
         Begin OptionButton IndexSelect 
            Caption         =   "Department"
            Height          =   195
            Index           =   3
            Left            =   120
            TabIndex        =   30
            Top             =   1260
            Width           =   1695
         End
         Begin OptionButton IndexSelect 
            Caption         =   "Job Title"
            Height          =   195
            Index           =   2
            Left            =   120
            TabIndex        =   29
            Top             =   960
            Width           =   1695
         End
         Begin OptionButton IndexSelect 
            Caption         =   "Last Name"
            Height          =   195
            Index           =   1
            Left            =   120
            TabIndex        =   28
            Top             =   660
            Width           =   1515
         End
         Begin OptionButton IndexSelect 
            Caption         =   "Social Security Number"
            Height          =   195
            Index           =   0
            Left            =   120
            TabIndex        =   27
            Top             =   360
            Value           =   -1  'True
            Width           =   2295
         End
      End
      Begin Label Label10 
         BackColor       =   &H00808000&
         Caption         =   "Soc. Sec. No., Last Name, Nickname, Job Title, Department, Salary, Golf Score"
         Height          =   195
         Left            =   60
         TabIndex        =   34
         Top             =   2100
         Width           =   8655
      End
   End
   Begin Frame RemoveFrame 
      Caption         =   "REMOVE a record:"
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   12
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   735
      Left            =   240
      TabIndex        =   18
      Top             =   1860
      Width           =   8775
      Begin CommandButton RemoveButton 
         Caption         =   "Remove"
         Height          =   315
         Left            =   5160
         TabIndex        =   23
         Top             =   360
         Width           =   975
      End
      Begin TextBox RemoveSSN 
         BackColor       =   &H00C0C0C0&
         Height          =   315
         Left            =   3840
         TabIndex        =   20
         Top             =   360
         Width           =   1215
      End
      Begin Label Label8 
         Caption         =   "Social Security Number (nnn-nn-nnnn):"
         Height          =   255
         Left            =   300
         TabIndex        =   19
         Top             =   420
         Width           =   3435
      End
      Begin Label RemoveLabel 
         Alignment       =   2  'Center
         BackColor       =   &H000000FF&
         Caption         =   "SSN not in file -- no record removed"
         FontBold        =   -1  'True
         FontItalic      =   -1  'True
         FontName        =   "MS Sans Serif"
         FontSize        =   7.8
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   435
         Left            =   6240
         TabIndex        =   21
         Top             =   240
         Visible         =   0   'False
         Width           =   2475
      End
   End
   Begin Frame AddFrame 
      Caption         =   "ADD a record:"
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   12
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   1575
      Left            =   240
      TabIndex        =   2
      Top             =   240
      Width           =   8775
      Begin TextBox AddGolfScore 
         BackColor       =   &H00C0C0C0&
         Height          =   315
         Left            =   7020
         TabIndex        =   16
         Top             =   1140
         Width           =   1695
      End
      Begin TextBox AddSalary 
         BackColor       =   &H00C0C0C0&
         Height          =   315
         Left            =   4080
         TabIndex        =   14
         Top             =   1140
         Width           =   1695
      End
      Begin TextBox AddNickname 
         BackColor       =   &H00C0C0C0&
         Height          =   315
         Left            =   1380
         TabIndex        =   8
         Top             =   1140
         Width           =   1695
      End
      Begin TextBox AddDepartment 
         BackColor       =   &H00C0C0C0&
         Height          =   315
         Left            =   7020
         TabIndex        =   12
         Top             =   780
         Width           =   1695
      End
      Begin TextBox AddJobTitle 
         BackColor       =   &H00C0C0C0&
         Height          =   315
         Left            =   4080
         TabIndex        =   10
         Top             =   780
         Width           =   1695
      End
      Begin TextBox AddLastName 
         BackColor       =   &H00C0C0C0&
         Height          =   315
         Left            =   1380
         TabIndex        =   6
         Top             =   780
         Width           =   1695
      End
      Begin CommandButton AddButton 
         Caption         =   "Add"
         Height          =   315
         Left            =   5160
         TabIndex        =   22
         Top             =   360
         Width           =   975
      End
      Begin TextBox AddSSN 
         BackColor       =   &H00C0C0C0&
         Height          =   315
         Left            =   3840
         TabIndex        =   4
         Top             =   360
         Width           =   1215
      End
      Begin Label Label7 
         Caption         =   "Golf Score:"
         Height          =   255
         Left            =   5880
         TabIndex        =   15
         Top             =   1200
         Width           =   1095
      End
      Begin Label Label6 
         Caption         =   "Salary:"
         Height          =   255
         Left            =   3180
         TabIndex        =   13
         Top             =   1200
         Width           =   735
      End
      Begin Label Label3 
         Caption         =   "Nickname:"
         Height          =   255
         Left            =   300
         TabIndex        =   7
         Top             =   1200
         Width           =   915
      End
      Begin Label Label5 
         Caption         =   "Department:"
         Height          =   255
         Left            =   5880
         TabIndex        =   11
         Top             =   840
         Width           =   1095
      End
      Begin Label Label4 
         Caption         =   "Job Title:"
         Height          =   255
         Left            =   3180
         TabIndex        =   9
         Top             =   840
         Width           =   855
      End
      Begin Label Label2 
         Caption         =   "Last Name:"
         Height          =   255
         Left            =   300
         TabIndex        =   5
         Top             =   840
         Width           =   1035
      End
      Begin Label Label1 
         Caption         =   "Social Security Number (nnn-nn-nnnn):"
         Height          =   255
         Left            =   300
         TabIndex        =   3
         Top             =   420
         Width           =   3435
      End
      Begin Label AddLabel 
         Alignment       =   2  'Center
         BackColor       =   &H000000FF&
         Caption         =   "Duplicate SSN -- record not added"
         FontBold        =   -1  'True
         FontItalic      =   -1  'True
         FontName        =   "MS Sans Serif"
         FontSize        =   7.8
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   435
         Left            =   6240
         TabIndex        =   17
         Top             =   240
         Visible         =   0   'False
         Width           =   2475
      End
   End
End




                                           






















Sub AddButton_Click ()
    
    ClearResults
    MatchKey.Text = ""

    If Len(AddSSN.Text) <> 11 Then
        MsgBox "Soc. Sec. No. must be exactly 11 characters -- try again.", 48, "SAM1"
        Exit Sub
    End If
    If Len(AddLastName.Text) > 20 Or Len(AddLastName.Text) < 1 Then
        MsgBox "Last name must be between 1 and 20 characters -- try again.", 48, "SAM1"
        Exit Sub
    End If
    If Len(AddJobTitle.Text) > 20 Or Len(AddJobTitle.Text) < 1 Then
        MsgBox "Job title must be between 1 and 20 characters -- try again.", 48, "SAM1"
        Exit Sub
    End If
    If Len(AddDepartment.Text) > 20 Or Len(AddJobTitle.Text) < 1 Then
        MsgBox "Department must be between 1 and 20 characters -- try again.", 48, "SAM1"
        Exit Sub
    End If
    If Len(AddNickname.Text) < 1 Then
        MsgBox "What, no nickname? -- try again.", 48, "SAM1"
        Exit Sub
    End If
    Sal% = Val(AddSalary.Text)
    If Sal% < 1 Or Sal% > 30000 Then
        MsgBox "(Monthly) salary should be between 1 and 30000 -- try again.", 48, "SAM1"
        Exit Sub
    End If
    Golf% = Val(AddGolfScore.Text)
    If Golf% < 50 Or Golf% > 300 Then
        MsgBox "Golf score should be between 50 and 300 -- try again.", 48, "SAM1"
        Exit Sub
    End If

    PersonRecord.LastName = AddLastName.Text
    PersonRecord.Nickname = AddNickname.Text
    PersonRecord.JobTitle = AddJobTitle.Text
    PersonRecord.Department = AddDepartment.Text
    PersonRecord.Salary = Sal%
    PersonRecord.GolfScore = Golf%

    rc = VmxPut(Handle, (AddSSN.Text), PersonRecord, ADD_ONLY)

    If rc = VIS_OK Then
        AddLabel.Caption = "Record successfully added"
    ElseIf rc = VIS_UPDATE_VIOLATION Then
        AddLabel.Caption = "Duplicate SSN -- no record added"
    Else
        ErrorExit (1)
    End If
    AddLabel.Visible = VB1TRUE

End Sub

Sub AddDepartment_Change ()
    AddLabel.Visible = VB1FALSE
End Sub

Sub AddGolfScore_Change ()
    AddLabel.Visible = VB1FALSE
End Sub

Sub AddJobTitle_Change ()
    AddLabel.Visible = VB1FALSE
End Sub

Sub AddLastName_Change ()
    AddLabel.Visible = VB1FALSE
End Sub

Sub AddNickname_Change ()
    AddLabel.Visible = VB1FALSE
End Sub

Sub AddSalary_Change ()
    AddLabel.Visible = VB1FALSE
End Sub

Sub AddSSN_Change ()
    AddLabel.Visible = VB1FALSE
End Sub

Sub BuildDisplayString ()

    DisplayString = "  "
    DisplayString = DisplayString + SocSecNo + ",  "
    DisplayString = DisplayString + PersonRecord.LastName + ",  "
    DisplayString = DisplayString + PersonRecord.Nickname + ",  "
    DisplayString = DisplayString + PersonRecord.JobTitle + ",  "
    DisplayString = DisplayString + PersonRecord.Department + ",  "
    DisplayString = DisplayString + Str$(PersonRecord.Salary) + ",  "
    DisplayString = DisplayString + Str$(PersonRecord.GolfScore)

End Sub

Sub ClearResults ()

    AddLabel.Visible = VB1FALSE
    RemoveLabel.Visible = VB1FALSE

    For I% = 0 To 7
        FindIndicator(I%).Visible = VB1FALSE  'Clear out the red asterisk
    Next I%

    Do While FindList.ListCount
        FindList.RemoveItem 0
    Loop

End Sub

Sub DisplayTheRecord ()

    BuildDisplayString
    FindList.AddItem DisplayString

End Sub

Sub ErrorExit (ErrorCode As Integer)

    If ErrorCode <> 4 Then
        MsgBox "Error exit from demo program; see source code for error code " + Str$(ErrorCode) + ".", 16, "SAM1"
        rc = VmxClose(Handle)
        If rc = VIS_OK Then End
    End If
    MsgBox "Problem in closing the dataset SAM1DAT from this demo program; see source code for error code " + Str$(ErrorCode) + ".  Exit VB to close any remaining open files.", 16, "SAM1"
    End

End Sub

Sub FindButton_Click (Index As Integer)

    ClearResults
    
    FindTypeChoice = Index

    If FindTypeChoice = 2 Or FindTypeChoice = 6 Then    'key match
        If IndexChoice = 0 Then                         'primary key (SSN)
            If Len(MatchKey.Text) <> 11 Then
                MsgBox "You must enter an 11-character Soc. Sec. No. in the match key -- try again.", 48, "SAM1"
                Exit Sub
            End If
        ElseIf Len(MatchKey.Text) > 20 Or Len(MatchKey.Text) < 1 Then
            MsgBox "Match key for last name, job title, or department must be between 1 and 20 characters -- try again.", 48, "SAM1"
            Exit Sub
        End If
    Else
        MatchKey.Text = ""
    End If

    FindIndicator(FindTypeChoice).Visible = VB1TRUE    'Turn on red asterisk to
                                                    'remind the user, after
                                                    'the operation, which kind
                                                    'of operation yielded the
                                                    'visible results.

    Select Case FindTypeChoice
        Case 0
            FindFirstOne
        Case 1
            FindPreviousOne
        Case 2
            FindKeyMatchOne
        Case 3
            FindNextOne
        Case 4
            FindLastOne
        Case 5
            FindPreviousGroup
        Case 6
            FindKeyMatchGroup
        Case 7
            FindNextGroup
    End Select

End Sub

Sub FindFirstOne ()

    rc = VmxBOF(Handle, SelectedIndex)
    If rc <> VIS_OK Then ErrorExit (6)
    
    rc = VmxGet(Handle, SelectedIndex, XNEXT, "", Throwaway$, SocSecNo, PersonRecord)
        
        'Explanation:  We could have said XNEXT+XANY+XGET_DATA, but the latter
        'two components of the Option% are the defaults.  The SelectorKey$
        'is used for neither lookup nor comparison, so we just used the
        'null string.  We don't need to know the returned secondary
        'key, so we can throw it away.
    
    If rc = VIS_NOT_FOUND Then
        FindList.AddItem "<<File is empty>>"
    ElseIf rc <> VIS_OK Then
        ErrorExit (7)
    Else
        DisplayTheRecord
    End If

End Sub

Sub FindKeyMatchGroup ()

    rc = VmxGet(Handle, SelectedIndex, 0, (MatchKey.Text), Throwaway$, SocSecNo, PersonRecord)

                'That was a lookup on MatchKey.Text.  Note the technique of
                'supplying a "Throwaway$" string variable for the returned
                'index entry; you never need this on a lookup, since it's
                'going to be equal to the lookup key if the lookup succeeds,
                'and won't be set if the lookup fails.  Some people, though,
                'like to code consistent-looking calls, and you can refer
                'to this argument for the current index key value for all
                'four types of VmxGet access (Lookup, Next, Previous, Current).

    If rc = VIS_NOT_FOUND Then
        FindList.AddItem "<<No match>>"
    ElseIf rc <> VIS_OK Then
        ErrorExit (8)

    Else    'This loop is a classic example of finding "duplicate keys."
        Do
            DisplayTheRecord
            rc = VmxGet(Handle, SelectedIndex, XNEXT + XEQ, (MatchKey.Text), Throwaway$, SocSecNo, PersonRecord)
        Loop While rc = VIS_OK
        If rc <> VIS_NOT_FOUND Then ErrorExit (9)

        'Note that we just went one entry too far in the index, which would
        'cause a subsequent use of a "Next" access to miss a record.
            '(Don't panic -- that's just the kind of logic I wanted for
            'THIS PROGRAM.)
        'Therefore, we need to back up by one entry in this index.
        'By the way, this works even if there's only one entry in the
        'index (in which case the "Next" took us to EOF, and the "Previous"
        'will take us back to the entry):

        rc = VmxGet(Handle, SelectedIndex, XPREVIOUS + XANY + XNO_DATA, "", Throwaway$, Throwaway$, PersonRecord)
    
        'This was an example of using VmxGet just to move around (i.e.,
        'set pointer position) in an index, without needing any returned
        'information at all!  (I didn't need the "XANY" except for
        'clarity of documentation.)

        If rc <> VIS_OK Then ErrorExit (10)

    End If

End Sub

Sub FindKeyMatchOne ()

    rc = VmxGet(Handle, SelectedIndex, 0, (MatchKey.Text), Throwaway$, SocSecNo, PersonRecord)
    
        'See NextKeyMatchGroup for remarks on the use of VmxGet.  The "0," by
        'the way, specifies the default options for VmxGet:  Lookup access
        'mode (as opposed to Next, Previous, or Current step-wise access), and
        'full data retrieval (as opposed to retrieving only the primary key.

    If rc = VIS_NOT_FOUND Then
        FindList.AddItem "<<No match>> ...but note that the pointer for this index has been"
        FindList.AddItem "repositioned to where your match key WOULD BE; if you now move"
        FindList.AddItem "forward (Next) or backward (Previous) in this index, the step will"
        FindList.AddItem "begin FROM THAT 'INSERTION POINT.'"
    ElseIf rc <> VIS_OK Then
        ErrorExit (11)
    Else
        DisplayTheRecord
    End If

End Sub

Sub FindLastOne ()

    rc = VmxEOF(Handle, SelectedIndex)
    If rc <> VIS_OK Then ErrorExit (12)
    
    rc = VmxGet(Handle, SelectedIndex, XPREVIOUS, "", Throwaway$, SocSecNo, PersonRecord)
    
    If rc = VIS_NOT_FOUND Then
        FindList.AddItem "<<File is empty>>"
    ElseIf rc <> VIS_OK Then
        ErrorExit (13)
    Else
        DisplayTheRecord
    End If
    
End Sub

Sub FindNextGroup ()

    SaveCurrentRecord
    
    rc = VmxGet(Handle, SelectedIndex, XNEXT, "", GroupKey, SocSecNo, PersonRecord)

    If rc = VIS_NOT_FOUND Then  'This means we just stepped beyond the last record.
        FindList.AddItem "<<At End of File>>"
    ElseIf rc <> VIS_OK Then
        ErrorExit (14)
    Else
        If GroupKey = SaveKey Then FindList.AddItem SaveDisplayString 'Include current record if same index-key value
        Do
            DisplayTheRecord
            rc = VmxGet(Handle, SelectedIndex, XNEXT + XEQ, GroupKey, Throwaway$, SocSecNo, PersonRecord)
        Loop While rc = VIS_OK
        'Note that we just went one entry too far in the file, which would
        'cause a subsequent use of FindNextOne to miss its target.
        'Therefore, we need to back up by one entry in this file:
        rc = VmxGet(Handle, SelectedIndex, XPREVIOUS + XANY + XNO_DATA, "", Throwaway$, Throwaway$, PersonRecord)
            
            'See FindKeyMatchGroup for remarks on a similar function call.
        
        If rc <> VIS_OK Then ErrorExit (15)
    End If

End Sub

Sub FindNextOne ()

    rc = VmxGet(Handle, SelectedIndex, XNEXT, "", Throwaway$, SocSecNo, PersonRecord)

    If rc = VIS_NOT_FOUND Then  'This means we just stepped beyond the last record.
        FindList.AddItem "<<At End of File>>"
    ElseIf rc <> VIS_OK Then
        ErrorExit (16)
    Else
        DisplayTheRecord
    End If

End Sub

Sub FindPreviousGroup ()

    SaveCurrentRecord
    
    rc = VmxGet(Handle, SelectedIndex, XPREVIOUS, "", GroupKey, SocSecNo, PersonRecord)

        'Note that this time, we're interested in the returned index entry.

    If rc = VIS_NOT_FOUND Then  'This means we just stepped (backwards)
                                'to before the first record.
        FindList.AddItem "<<At Beginning of File>>"
    ElseIf rc <> VIS_OK Then
        ErrorExit (17)
    Else
        If GroupKey = SaveKey Then FindList.AddItem SaveDisplayString 'Include current record if same index-key value
        Do
            DisplayTheRecord
            rc = VmxGet(Handle, SelectedIndex, XPREVIOUS + XEQ, GroupKey, Throwaway$, SocSecNo, PersonRecord)
        Loop While rc = VIS_OK
        'Note that we just went one entry too far (backwards) in the file, which would
        'cause a subsequent use of FindPreviousOne to miss its target.
        'Therefore, we need to go forward by one entry in this file:
        rc = VmxGet(Handle, SelectedIndex, XNEXT + XANY + XNO_DATA, "", Throwaway$, Throwaway$, PersonRecord)
            'See FindKeyMatchGroup for remarks on a similar function call.
        If rc <> VIS_OK Then ErrorExit (18)
    End If

End Sub

Sub FindPreviousOne ()

    rc = VmxGet(Handle, SelectedIndex, XPREVIOUS, "", Throwaway$, SocSecNo, PersonRecord)

    If rc = VIS_NOT_FOUND Then  'This means we just stepped (backwards)
                                'to before the first record.
        FindList.AddItem "<<At Beginning of File>>"
    ElseIf rc <> VIS_OK Then
        ErrorExit (19)
    Else
        DisplayTheRecord
    End If

End Sub

Sub Form_Load ()

    IndexSelect_Click (0)

End Sub

Sub IndexSelect_Click (Index As Integer)


    ClearResults
    MatchKey.Text = ""

    IndexChoice = Index

    FindButton(5).Enabled = VB1TRUE
    FindButton(6).Enabled = VB1TRUE
    FindButton(7).Enabled = VB1TRUE

    Select Case IndexChoice
        Case 0
            SelectedIndex = XSOCSECNO
            FindButton(5).Enabled = VB1FALSE     'no "group" finds on primary key --
            FindButton(6).Enabled = VB1FALSE     'By definition, the primary index
            FindButton(7).Enabled = VB1FALSE     'consists of UNIQUE record identifiers.
        Case 1
            SelectedIndex = XLASTNAME
        Case 2
            SelectedIndex = XJOBTITLE
        Case 3
            SelectedIndex = XDEPARTMENT
    End Select

    rc = VmxBOF(Handle, SelectedIndex)      'VmxBOF sets an index pointer to the top.
    If rc <> VIS_OK Then ErrorExit (2)

End Sub

Sub KillQuitButton_Click ()

    rc = MsgBox("Do you really want to delete all this lovely data, without hope of it again enriching your meager existence?", 308, "SAM1")
    If rc = 7 Then Exit Sub '("No")

    rc = VmxClose(Handle)
    If rc <> VIS_OK Then ErrorExit (4)

    rc = VmxKill(DATASETNAME)
    If rc <> VIS_OK Then MsgBox "Problem -- unable to kill SAM1DAT", 16, "SAM1"

    End

End Sub

Sub MatchKey_Change ()

    ClearResults

End Sub

Sub QuitButton_Click ()
    
    rc = VmxClose(Handle)
    If rc <> VIS_OK Then ErrorExit (4)

    End

End Sub

Sub RemoveButton_Click ()

    ClearResults
    MatchKey.Text = ""

    If Len(RemoveSSN.Text) <> 11 Then
        MsgBox "Soc. Sec. No. must be exactly 11 characters -- try again.", 48, "SAM1"
        Exit Sub
    End If

    rc = VmxDelete(Handle, (RemoveSSN.Text))

    If rc = VIS_OK Then
        RemoveLabel.Caption = "Record successfully removed"
    ElseIf rc = VIS_NOT_FOUND Then
        RemoveLabel.Caption = "SSN not in file -- no record removed"
    Else
        ErrorExit (3)
    End If
    RemoveLabel.Visible = VB1TRUE

End Sub

Sub RemoveSSN_Change ()

    RemoveLabel.Visible = VB1FALSE

End Sub

Sub SaveCurrentRecord ()

'The purpose of this subroutine is to provide FindNextGroup and FindPreviousGroup
'with knowledge of the current index key value, so that they can re-display
'the corresponding record if the next/previous index key value is the same.

    rc = VmxGet(Handle, SelectedIndex, XCURRENT, "", SaveKey, SocSecNo, PersonRecord)
    If rc = VIS_NOT_FOUND Then
        SaveKey = ""
    ElseIf rc = VIS_OK Then
        BuildDisplayString
        SaveDisplayString = DisplayString
    Else ErrorExit (5)
    End If

End Sub

